﻿using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;


namespace RomanClient
{
	/// <summary>
	/// Summary description for WinForm1.
	/// </summary>
	public class WinForm1 : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox tbNum;
		private System.Windows.Forms.TextBox tbRom;
		private System.Windows.Forms.Button btnN2R;
		private System.Windows.Forms.Button btnR2N;
		private IRomanservice RC = null;

		public WinForm1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.tbNum = new System.Windows.Forms.TextBox();
			this.tbRom = new System.Windows.Forms.TextBox();
			this.btnN2R = new System.Windows.Forms.Button();
			this.btnR2N = new System.Windows.Forms.Button();
			this.SuspendLayout();
			//
			// label1
			//
			this.label1.Location = new System.Drawing.Point(16, 18);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(80, 23);
			this.label1.TabIndex = 0;
			this.label1.Text = "Numerical:";
			//
			// label2
			//
			this.label2.Location = new System.Drawing.Point(16, 48);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(80, 23);
			this.label2.TabIndex = 1;
			this.label2.Text = "Roman Digits:";
			//
			// tbNum
			//
			this.tbNum.Location = new System.Drawing.Point(96, 16);
			this.tbNum.Name = "tbNum";
			this.tbNum.TabIndex = 2;
			this.tbNum.Text = "42";
			//
			// tbRom
			//
			this.tbRom.Location = new System.Drawing.Point(96, 46);
			this.tbRom.Name = "tbRom";
			this.tbRom.TabIndex = 3;
			this.tbRom.Text = "XLII";
			// 
			// btnN2R
			// 
			this.btnN2R.Location = new System.Drawing.Point(16, 88);
			this.btnN2R.Name = "btnN2R";
			this.btnN2R.TabIndex = 4;
			this.btnN2R.Text = "Num 2 Rom";
			this.btnN2R.Click += new System.EventHandler(this.btnN2R_Click);
			// 
			// btnR2N
			// 
			this.btnR2N.Location = new System.Drawing.Point(120, 88);
			this.btnR2N.Name = "btnR2N";
			this.btnR2N.TabIndex = 5;
			this.btnR2N.Text = "Rom 2 Num";
			this.btnR2N.Click += new System.EventHandler(this.btnR2N_Click);
			// 
			// WinForm1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(224, 125);
			this.Controls.Add(this.btnR2N);
			this.Controls.Add(this.btnN2R);
			this.Controls.Add(this.tbRom);
			this.Controls.Add(this.tbNum);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Name = "WinForm1";
			this.Text = "Roman Web Service Client";
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm1());
		}

		private void Init_RC()
		{
			if (RC == null)
			try
			{
				RC = new IRomanservice();
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message, "Error");
			}
		}

		private void btnN2R_Click(object sender, System.EventArgs e)
		{
			Init_RC();
			tbRom.Text = Convert.ToString
				(RC.IntToRoman(Convert.ToInt32(tbNum.Text)));
		}

		private void btnR2N_Click(object sender, System.EventArgs e)
		{
			Init_RC();
			tbNum.Text = Convert.ToString(RC.RomanToInt(tbRom.Text));
		}
	}
}
